import jwt from "jsonwebtoken";
import { config } from "../config/app.config.js";

const defaults = {
  audience: ["user"],
};

const accessTokenSignOptions = {
  expiresIn: config.JWT_EXPIRES_IN,
  secret: config.JWT_SECRET,
};

export const signJwtToken = (
  payload,
  options
) => {
  const { secret, ...opts } = options || accessTokenSignOptions;
  const token = jwt.sign(payload, secret, {
    ...defaults,
    ...opts,
  });

  const decodedToken = jwt.decode(token);
  const expiresAt = decodedToken?.exp ? decodedToken.exp * 1000 : null;

  return {
    token,
    expiresAt,
  };
};
