import { Router } from "express";
import { passportAuthenticateJwt } from "../config/passport.config.js";
import {
  getAvailabilityForPublicEventController,
  getUserAvailabilityController,
  updateAvailabilityController,
} from "../controllers/availability.controller.js";

const availabilityRoutes = Router();

availabilityRoutes.get(
  "/me",
  passportAuthenticateJwt,
  getUserAvailabilityController
);

availabilityRoutes.get(
  "/public/:eventId",
  getAvailabilityForPublicEventController
);

availabilityRoutes.put(
  "/update",
  passportAuthenticateJwt,
  updateAvailabilityController
);
export default availabilityRoutes;
