import mongoose, { Schema } from "mongoose";
import { v4 as uuidv4 } from "uuid";

export const MeetingStatus = {
  SCHEDULED: "SCHEDULED",
  CANCELLED: "CANCELLED",
};

const MeetingSchema = new Schema(
  {
    _id: { type: String, default: uuidv4 },
    user: { type: String, ref: "User", required: true },
    event: { type: String, ref: "Event", required: true },
    guestName: { type: String, required: true },
    guestEmail: { type: String, required: true },
    additionalInfo: { type: String },
    startTime: { type: Date, required: true },
    endTime: { type: Date, required: true },
    meetLink: { type: String, required: true },
    calendarEventId: { type: String, required: true },
    calendarAppType: { type: String, required: true },
    status: {
      type: String,
      enum: Object.values(MeetingStatus),
      default: MeetingStatus.SCHEDULED,
    },
  },
  {
    timestamps: true,
    toJSON: {
      virtuals: true,
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
      },
    },
    toObject: { virtuals: true },
  }
);

export const MeetingModel = mongoose.model("Meeting", MeetingSchema);
