import mongoose, { Schema } from "mongoose";
import { v4 as uuidv4 } from "uuid";

export const IntegrationProviderEnum = {
  GOOGLE: "GOOGLE",
  ZOOM: "ZOOM",
  MICROSOFT: "MICROSOFT",
  SALESFORCE: "SALESFORCE",
  HUBSPOT: "HUBSPOT",
  ZAPIER: "ZAPIER",
};

export const IntegrationAppTypeEnum = {
  GOOGLE_MEET_AND_CALENDAR: "GOOGLE_MEET_AND_CALENDAR",
  ZOOM_MEETING: "ZOOM_MEETING",
  OUTLOOK_CALENDAR: "OUTLOOK_CALENDAR",
  SALESFORCE: "SALESFORCE",
  HUBSPOT: "HUBSPOT",
  ZAPIER: "ZAPIER",
};

export const IntegrationCategoryEnum = {
  CALENDAR_AND_VIDEO_CONFERENCING: "CALENDAR_AND_VIDEO_CONFERENCING",
  VIDEO_CONFERENCING: "VIDEO_CONFERENCING",
  CALENDAR: "CALENDAR",
  CRM: "CRM",
  AUTOMATION: "AUTOMATION",
};

const IntegrationSchema = new Schema(
  {
    _id: { type: String, default: uuidv4 },
    provider: { type: String, enum: Object.values(IntegrationProviderEnum), required: true },
    category: { type: String, enum: Object.values(IntegrationCategoryEnum), required: true },
    app_type: { type: String, enum: Object.values(IntegrationAppTypeEnum), required: true },
    access_token: { type: String, required: true },
    refresh_token: { type: String },
    expiry_date: { type: Number },
    metadata: { type: Schema.Types.Mixed },
    isConnected: { type: Boolean, default: true },
    user: { type: String, ref: "User", required: true },
  },
  {
    timestamps: true,
    toJSON: {
      virtuals: true,
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
      },
    },
    toObject: { virtuals: true },
  }
);

export const IntegrationModel = mongoose.model("Integration", IntegrationSchema);
