import mongoose, { Schema } from "mongoose";
import { v4 as uuidv4 } from "uuid";
import { IntegrationAppTypeEnum } from "./integration.model.js";

export const EventLocationEnumType = {
  GOOGLE_MEET_AND_CALENDAR: IntegrationAppTypeEnum.GOOGLE_MEET_AND_CALENDAR,
  ZOOM_MEETING: IntegrationAppTypeEnum.ZOOM_MEETING,
};

const EventSchema = new Schema(
  {
    _id: { type: String, default: uuidv4 },
    title: { type: String, required: true },
    description: { type: String },
    duration: { type: Number, default: 30 },
    slug: { type: String, required: true },
    isPrivate: { type: Boolean, default: false },
    locationType: { type: String, enum: Object.values(EventLocationEnumType), required: true },
    user: { type: String, ref: "User", required: true },
  },
  {
    timestamps: true,
    toJSON: {
      virtuals: true,
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
      },
    },
    toObject: { virtuals: true },
  }
);

// Virtual for meetings
EventSchema.virtual("meetings", {
  ref: "Meeting",
  localField: "_id",
  foreignField: "event",
});

export const EventModel = mongoose.model("Event", EventSchema);
