import mongoose, { Schema } from "mongoose";
import { v4 as uuidv4 } from "uuid";

export const DayOfWeekEnum = {
  SUNDAY: "SUNDAY",
  MONDAY: "MONDAY",
  TUESDAY: "TUESDAY",
  WEDNESDAY: "WEDNESDAY",
  THURSDAY: "THURSDAY",
  FRIDAY: "FRIDAY",
  SATURDAY: "SATURDAY",
};

const DayAvailabilitySchema = new Schema(
  {
    _id: { type: String, default: uuidv4 },
    day: { type: String, enum: Object.values(DayOfWeekEnum), required: true },
    startTime: { type: Date, required: true },
    endTime: { type: Date, required: true },
    isAvailable: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      virtuals: true,
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
      },
    },
    toObject: { virtuals: true },
  }
);

const AvailabilitySchema = new Schema(
  {
    _id: { type: String, default: uuidv4 },
    user: { type: String, ref: "User" },
    days: [DayAvailabilitySchema],
    timeGap: { type: Number, default: 30 },
  },
  {
    timestamps: true,
    toJSON: {
      virtuals: true,
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
        if (ret.days) {
            ret.days.forEach((day) => {
                day.id = day._id;
                delete day._id;
                delete day.__v;
            });
        }
      },
    },
    toObject: { virtuals: true },
  }
);

export const AvailabilityModel = mongoose.model("Availability", AvailabilitySchema);
