import {
  IsDateString,
  IsEmail,
  IsNotEmpty,
  IsOptional,
  IsString,
  IsUUID,
} from "class-validator";

export class CreateMeetingDto {}
IsString()(CreateMeetingDto.prototype, "eventId");
IsNotEmpty()(CreateMeetingDto.prototype, "eventId");
IsDateString()(CreateMeetingDto.prototype, "startTime");
IsNotEmpty()(CreateMeetingDto.prototype, "startTime");
IsDateString()(CreateMeetingDto.prototype, "endTime");
IsNotEmpty()(CreateMeetingDto.prototype, "endTime");
IsString()(CreateMeetingDto.prototype, "guestName");
IsNotEmpty()(CreateMeetingDto.prototype, "guestName");
IsEmail()(CreateMeetingDto.prototype, "guestEmail");
IsNotEmpty()(CreateMeetingDto.prototype, "guestEmail");
IsString()(CreateMeetingDto.prototype, "additionalInfo");
IsOptional()(CreateMeetingDto.prototype, "additionalInfo");

export class MeetingIdDTO {}
IsUUID(4, { message: "Invaild uuid" })(MeetingIdDTO.prototype, "meetingId");
IsNotEmpty()(MeetingIdDTO.prototype, "meetingId");
