import {
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsUUID,
} from "class-validator";
import { EventLocationEnumType } from "../models/event.model.js";

export class CreateEventDto {}
IsString()(CreateEventDto.prototype, "title");
IsNotEmpty()(CreateEventDto.prototype, "title");
IsString()(CreateEventDto.prototype, "description");
IsOptional()(CreateEventDto.prototype, "description");
IsNumber()(CreateEventDto.prototype, "duration");
IsNotEmpty()(CreateEventDto.prototype, "duration");
IsEnum(EventLocationEnumType)(CreateEventDto.prototype, "locationType");
IsNotEmpty()(CreateEventDto.prototype, "locationType");

export class EventIdDTO {}
IsUUID(4, { message: "Invaild uuid" })(EventIdDTO.prototype, "eventId");
IsNotEmpty()(EventIdDTO.prototype, "eventId");

export class UserNameDTO {}
IsString()(UserNameDTO.prototype, "username");
IsNotEmpty()(UserNameDTO.prototype, "username");

export class UserNameAndSlugDTO {}
IsString()(UserNameAndSlugDTO.prototype, "username");
IsNotEmpty()(UserNameAndSlugDTO.prototype, "username");
IsString()(UserNameAndSlugDTO.prototype, "slug");
IsNotEmpty()(UserNameAndSlugDTO.prototype, "slug");

export class UpdateEventDto {}
IsString()(UpdateEventDto.prototype, "title");
IsOptional()(UpdateEventDto.prototype, "title");
IsString()(UpdateEventDto.prototype, "description");
IsOptional()(UpdateEventDto.prototype, "description");
IsNumber()(UpdateEventDto.prototype, "duration");
IsOptional()(UpdateEventDto.prototype, "duration");
IsEnum(EventLocationEnumType)(UpdateEventDto.prototype, "locationType");
IsOptional()(UpdateEventDto.prototype, "locationType");
