import {
  IsArray,
  IsBoolean,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsString,
  ValidateNested,
} from "class-validator";
import { DayOfWeekEnum } from "../models/availability.model.js";
import { Type } from "class-transformer";

export class DayAvailabilityDto {}
IsEnum(DayOfWeekEnum)(DayAvailabilityDto.prototype, "day");
IsNotEmpty()(DayAvailabilityDto.prototype, "day");
IsString()(DayAvailabilityDto.prototype, "startTime");
IsNotEmpty()(DayAvailabilityDto.prototype, "startTime");
IsString()(DayAvailabilityDto.prototype, "endTime");
IsNotEmpty()(DayAvailabilityDto.prototype, "endTime");
IsBoolean()(DayAvailabilityDto.prototype, "isAvailable");
IsNotEmpty()(DayAvailabilityDto.prototype, "isAvailable");

export class UpdateAvailabilityDto {}
IsNumber()(UpdateAvailabilityDto.prototype, "timeGap");
IsNotEmpty()(UpdateAvailabilityDto.prototype, "timeGap");
IsArray()(UpdateAvailabilityDto.prototype, "days");
ValidateNested({ each: true })(UpdateAvailabilityDto.prototype, "days");
Type(() => DayAvailabilityDto)(UpdateAvailabilityDto.prototype, "days");
