import mongoose from "mongoose";
import { config } from "../config/app.config.js";

export const initializeDatabase = async () => {
  try {
    const dbUrl = config.DATABASE_URL;
    if (!dbUrl) {
        throw new Error("DATABASE_URL is not defined");
    }
    await mongoose.connect(dbUrl);
    console.log("MongoDB connected successfully");
  } catch (error) {
    console.error("Database connection error:", error);
    process.exit(1);
  }
};
