import { asyncHandler } from "../middlewares/asyncHandler.middeware.js";
import { HTTPSTATUS } from "../config/http.config.js";
import { MeetingFilterEnum } from "../enums/meeting.enum.js";
import {
  cancelMeetingService,
  createMeetBookingForGuestService,
  getUserMeetingsService,
} from "../services/meeting.service.js";
import { asyncHandlerAndValidation } from "../middlewares/withValidation.middleware.js";
import { CreateMeetingDto, MeetingIdDTO } from "../database/dto/meeting.dto.js";

export const getUserMeetingsController = asyncHandler(
  async (req, res) => {
    const userId = req.user?.id;

    const filter =
      req.query.filter || MeetingFilterEnum.UPCOMING;

    const meetings = await getUserMeetingsService(userId, filter);

    return res.status(HTTPSTATUS.OK).json({
      message: "Meetings fetched successfully",
      meetings,
    });
  }
);

// For Public
export const createMeetBookingForGuestController = asyncHandlerAndValidation(
  CreateMeetingDto,
  "body",
  async (req, res, createMeetingDto) => {
    const { meetLink, meeting } = await createMeetBookingForGuestService(
      createMeetingDto
    );
    return res.status(HTTPSTATUS.CREATED).json({
      message: "Meeting scheduled successfully",
      data: {
        meetLink,
        meeting,
      },
    });
  }
);

export const cancelMeetingController = asyncHandlerAndValidation(
  MeetingIdDTO,
  "params",
  async (req, res, meetingIdDto) => {
    await cancelMeetingService(meetingIdDto.meetingId);
    return res.status(HTTPSTATUS.OK).json({
      message: "Meeting cancelled successfully",
    });
  }
);
