import { asyncHandler } from "../middlewares/asyncHandler.middeware.js";
import { HTTPSTATUS } from "../config/http.config.js";
import {
  getAvailabilityForPublicEventService,
  getUserAvailabilityService,
  updateAvailabilityService,
} from "../services/availability.service.js";
import { asyncHandlerAndValidation } from "../middlewares/withValidation.middleware.js";
import { UpdateAvailabilityDto } from "../database/dto/availability.dto.js";
import { EventIdDTO } from "../database/dto/event.dto.js";

export const getUserAvailabilityController = asyncHandler(
  async (req, res) => {
    const userId = req.user?.id;

    const availability = await getUserAvailabilityService(userId);

    return res.status(HTTPSTATUS.OK).json({
      message: "Fetched availability successfully",
      availability,
    });
  }
);

export const updateAvailabilityController = asyncHandlerAndValidation(
  UpdateAvailabilityDto,
  "body",
  async (req, res, updateAvailabilityDto) => {
    const userId = req.user?.id;

    await updateAvailabilityService(userId, updateAvailabilityDto);

    return res.status(HTTPSTATUS.OK).json({
      message: "Availability updated successfully",
    });
  }
);

// For Public Event
export const getAvailabilityForPublicEventController =
  asyncHandlerAndValidation(
    EventIdDTO,
    "params",
    async (req, res, eventIdDto) => {
      const availability = await getAvailabilityForPublicEventService(
        eventIdDto.eventId
      );
      return res.status(HTTPSTATUS.OK).json({
        message: "Event availability fetched successfully",
        data: availability,
      });
    }
  );
