import { HTTPSTATUS } from "../config/http.config.js";
import { LoginDto, RegisterDto } from "../database/dto/auth.dto.js";
import { asyncHandlerAndValidation } from "../middlewares/withValidation.middleware.js";
import { loginService, registerService } from "../services/auth.service.js";

export const registerController = asyncHandlerAndValidation(
  RegisterDto,
  "body",
  async (req, res, registerDTO) => {
    const { user } = await registerService(registerDTO);

    return res.status(HTTPSTATUS.CREATED).json({
      message: "User created successfully",
      user,
    });
  }
);

export const loginController = asyncHandlerAndValidation(
  LoginDto,
  "body",
  async (req, res, loginDto) => {
    const { user, accessToken, expiresAt } = await loginService(loginDto);
    return res.status(HTTPSTATUS.CREATED).json({
      message: "User logged in successfully",
      user,
      accessToken,
      expiresAt,
    });
  }
);
